<?php

namespace UtillzCore\Inc\Src\Form\Modules\Upload;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Upload extends Module {

    public $thumbnail_size = 'ulz_thumbnail';

    public function before_construct() {
        $this->defaults += [
            'multiple_upload' => false,
            'upload_type' => 'image',
            'is_admin' => is_admin() && ! wp_doing_ajax(),
            'button' => [
                'label' => esc_html__('Upload', 'utillz-core')
            ],
            'display_info' => true
        ];
    }

    public function after_build() {
        $this->props->single = true;
        $this->attrs['data-multiple'] = $this->props->multiple_upload ? 'true' : 'false';
        $this->attrs['data-upload-type'] = $this->props->upload_type;
    }

    public function finish() {}

    public function controller() {

        $preview = [];

        // single
        if( $this->props->multiple_upload ) {

            $json_value = Ucore()->json_decode( $this->props->value );

            if( json_last_error() === JSON_ERROR_NONE ) {
                if( is_array( $json_value ) ) {
                    foreach( $json_value as $image_id ) {
                        $image = $this->get_image( $image_id );
                        if( $image ) {
                            $preview[] = $image;
                        }
                    }
                }
            }

        }
        // multiple
        else{

            $image_attrs = Ucore()->json_decode( $this->props->value );

            if( isset( $image_attrs[0] ) ) {
                $image = $this->get_image( $image_attrs[0] );
                if( $image ) {
                    $preview[] = $image;
                }
            }

        }

        return array_merge( (array) $this->props, [
            'preview' => $preview,
            'strings' => (object) [
                'max_file_size' => esc_html__('Maximum upload file size: %s MB.', 'utillz-core'),
                'drag_reorder' => esc_html__('Drag to reorder.', 'utillz-core'),
            ]
        ]);

    }

    public function get_image( $image ) {
        if( isset( $image->id ) ) {

            $thumb = null;
            if( $this->props->upload_type == 'image' ) {
                $image_data = wp_get_attachment_image_src( $image->id, $this->thumbnail_size );
                if( isset( $image_data[0] ) ) {
                    $thumb = $image_data[0];
                }
            }

            return (object) [
                'id' => $image->id,
                'thumb' => $thumb,
                'url' => wp_get_attachment_url( $image->id ),
				'name' => basename( get_attached_file( $image->id ) ),
            ];

        }

    }

    public function before_save( $post_id, $value ) {

        if( is_array( $value ) ) {
            $value = json_encode( $value );
        }

        return $value;

    }

}
